<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php  init_head(); ?>
<div id="wrapper">
    <div class="content">
        <style>
            .device-card-item {
                display: flex;
                margin-bottom: 15px;
            }
            .device-card-item.hide {
                display: none !important;
            }
        </style>
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h4><?php echo _l('wshop_devices'); ?></h4>
                            </div>
                            <?php if(has_permission('workshop_device', '', 'create')){ ?>
                                <div class="col-md-6">
                                    <a href="#" onclick="device_modal(0); return false;" class="btn btn-info pull-right display-block">
                                        <?php echo _l('wshop_new'); ?>
                                    </a>
                                </div>
                            <?php } ?>
                        </div>

                        <?php 
                        $device_statuses = [
                            ['id' => 1, 'name' => _l('wshop_active')],
                            ['id' => 2, 'name' => _l('wshop_under_repair')],
                            ['id' => 3, 'name' => _l('wshop_waiting_repair')],
                            ['id' => 0, 'name' => _l('wshop_inactive')],
                        ];
                         ?>
                        <div class="row">
                            <div class="col-md-3">
                                <?php echo render_select('client_filter', $clients, ['userid', 'company'], '', '', ['data-none-selected-text' => _l('client')]); ?>
                            </div>
                            <div class="col-md-3">
                                <?php echo render_select('devices_filter', $devices, ['id', 'name'], '', '', ['data-none-selected-text' => _l('wshop_devices')]); ?>

                            </div>
                            <div class="col-md-3">
                                <?php echo render_select('model_filter', $models, ['id', 'name'], '', '', ['data-none-selected-text' => _l('wshop_models')]); ?>
                                
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="status_filter" class="control-label" style="margin-bottom: 0; display: block; opacity: 0; pointer-events: none; height: 0;">Status</label>
                                    <select name="status_filter" class="selectpicker" id="status_filter" data-width="100%" data-none-selected-text="<?php echo _l('wshop_status'); ?>">
                                        <option value=""></option>
                                        <?php foreach($device_statuses as $s){ ?>
                                            <option value="<?php echo $s['id']; ?>"><?php echo $s['name']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                        <hr>


                        <div class="row mtop15 mbot15">
                            <div class="col-md-12 text-right">
                                <div class="btn-group c-btn-group" role="group">
                                    <button type="button" class="btn btn-default active" id="btn-grid-view" onclick="switch_view('grid')"><i class="fa fa-th-large"></i></button>
                                    <button type="button" class="btn btn-default" id="btn-list-view" onclick="switch_view('list')"><i class="fa fa-list"></i></button>
                                </div>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                        
                        <div id="device-grid-view">
                            <div class="row" style="display: flex; flex-wrap: wrap;">
                            <?php 
                            $initial_limit = 16;
                            $count = 0;
                            foreach($devices as $device){ 
                                $count++;
                                $hidden_class = ($count > $initial_limit) ? 'hide' : '';
                                
                                $image_url = site_url('modules/workshop/assets/images/upload-image-icon.png');
                                if ($device['primary_profile_image'] != '' && file_exists(MAIN_IMAGE_DEVICES_IMAGES_FOLDER.$device['id'].'/'.$device['primary_profile_image'])) {
                                    $image_url = site_url('modules/workshop/uploads/main_image_devices/'.$device['id'].'/'.$device['primary_profile_image']);
                                }

                                $warranty_status_label = '';
                                $warranty_status_val = 'out_of_warranty';
                                if($device['warranty_expiry_date'] != null){
                                    if(strtotime($device['warranty_expiry_date']) > strtotime(date('Y-m-d'))){
                                        $warranty_status_label = '<span class="label label-success">'._l('wshop_being_under_warranty').'</span>';
                                        $warranty_status_val = 'being_under_warranty';
                                    }else{
                                        $warranty_status_label = '<span class="label label-warning">'._l('wshop_out_of_warranty').'</span>';
                                    }
                                }
                                
                                $status_border_color = '#777777'; // Default Gray (Inactive)
                                if(isset($device['status'])){
                                    if($device['status'] == 1){
                                        $status_border_color = '#84c529'; // Green (Active)
                                    } elseif($device['status'] == 2){
                                        $status_border_color = '#fc2d42'; // Red (Under Repair)
                                    } elseif($device['status'] == 3){
                                        $status_border_color = '#ff9900'; // Orange (Waiting)
                                    }
                                }
                            ?>
                                <div class="col-lg-3 col-md-4 col-sm-6 device-card-item <?php echo $hidden_class; ?>" 
                                     data-client-id="<?php echo $device['client_id']; ?>" 
                                     data-device-id="<?php echo $device['id']; ?>" 
                                     data-model-id="<?php echo $device['model_id']; ?>" 
                                     data-status="<?php echo (isset($device['status']) && $device['status'] !== '' ? $device['status'] : 0); ?>">
                                    <div class="panel_s" style="width: 100%; display: flex; flex-direction: column; margin-bottom: 0; border-top: 3px solid <?php echo $status_border_color; ?>;">
                                        <div class="panel-body" style="flex: 1; display: flex; flex-direction: column;">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div style="display: flex; justify-content: space-between; align-items: flex-start;">
                                                        <div style="min-width: 0; flex: 1; padding-right: 10px;">
                                                            <h4 class="no-margin bold" style="white-space: nowrap; overflow: hidden; text-overflow: ellipsis;" title="<?php echo $device['name']; ?>"><?php echo $device['name']; ?></h4>
                                                            <p class="text-muted small no-margin" style="white-space: nowrap; overflow: hidden; text-overflow: ellipsis;"><?php echo $device['client_company']; ?></p>
                                                        </div>
                                                        <div class="text-right" style="flex-shrink: 0;">
                                                            <div class="mtop5">
                                                                <?php if($warranty_status_label != ''){ ?>
                                                                    <?php echo $warranty_status_label; ?>
                                                                <?php } ?>
                                                                
                                                                <?php 
                                                                if(isset($device['next_maintenance_hour']) && $device['next_maintenance_hour'] > 0 && isset($device['current_hours'])){
                                                                    if($device['current_hours'] > $device['next_maintenance_hour']){
                                                                         echo '<i class="fa fa-exclamation-triangle text-danger mleft5" style="font-size: 1.2em;" data-toggle="tooltip" title="'._l('wshop_overdue_by').' '.number_format($device['current_hours'] - $device['next_maintenance_hour'], 0).' '._l('wshop_hours_km').'"></i>';
                                                                    }
                                                                }
                                                                ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="clearfix"></div>
                                            <div class="row mtop15">
                                                <div class="col-md-12">
                                                    <div style="height: 180px; overflow: hidden; border-radius: 10px; background: #f0f0f0; display: flex; align-items: center; justify-content: center;">
                                                        <img src="<?php echo $image_url; ?>" class="img-responsive center-block" style="max-height: 100%; object-fit: cover; width: 100%;">
                                                    </div>

                                                </div>
                                            </div>
                                            <div class="row mtop15 tw-flex-grow">
                                                <div class="col-md-12">
                                                     <div style="display: flex; align-items: center; margin-bottom: 5px; justify-content: space-between;">
                                                         <div style="display: flex; align-items: center; color: #777;">
                                                            <i class="fa fa-barcode text-center" style="margin-right: 8px; width: 16px;"></i>
                                                            <span style="white-space: nowrap; overflow: hidden; text-overflow: ellipsis; max-width: 100px;" title="<?php echo $device['code']; ?>"><?php echo $device['code']; ?></span>
                                                         </div>
                                                         <?php if(!empty($device['plate_number'])){ ?>
                                                            <div style="border: 1px solid #ccc; border-radius: 3px; display: inline-flex; align-items: stretch; background: white; height: 20px; line-height: 18px; font-weight: bold; overflow: hidden; box-shadow: 0 1px 2px rgba(0,0,0,0.1);">
                                                                <div style="background: #e6f7ff; color: #0099ff; padding: 0 3px; border-right: 1px solid #eee; font-size: 8px; display: flex; align-items: center; justify-content: center; width: 18px;">
                                                                    <div style="line-height: 1;">
                                                                        <div style="font-size: 6px;">🇰🇿</div>
                                                                        <div style="font-size: 8px; font-weight: bold;">KZ</div>
                                                                    </div>
                                                                </div>
                                                                <div style="padding: 0 5px; color: #000; font-family: 'Consolas', 'Monaco', monospace; font-size: 12px; letter-spacing: 1px; display: flex; align-items: center;">
                                                                    <?php echo $device['plate_number']; ?>
                                                                </div>
                                                            </div>
                                                         <?php } ?>
                                                     </div>
                                                     <div style="display: flex; align-items: center; color: #777; margin-bottom: 5px;">
                                                        <i class="fa fa-cubes text-center" style="margin-right: 8px; width: 16px;"></i>
                                                        <span style="white-space: nowrap; overflow: hidden; text-overflow: ellipsis;"><?php echo $device['category_name']; ?></span>
                                                     </div>
                                                     <div style="display: flex; align-items: center; color: #777; margin-bottom: 5px;">
                                                        <i class="fa fa-car text-center" style="margin-right: 8px; width: 16px;"></i>
                                                        <span style="white-space: nowrap; overflow: hidden; text-overflow: ellipsis;"><?php echo $device['model_name']; ?></span>
                                                     </div>
                                                </div>
                                            </div>
                                            <div class="row mtop15" style="margin-top: auto;">
                                                <div class="col-md-12">
                                                    <div style="margin-top: 10px;">
                                                        <div style="display: flex; gap: 10px;">
                                                            <?php if((has_permission('workshop_device', '', 'view') || has_permission('workshop_device', '', 'view_own') || is_admin())){ ?>
                                                                <a href="<?php echo admin_url('workshop/device_detail/'.$device['id']); ?>" class="btn btn-default" style="flex: 1; padding: 8px 0;" title="<?php echo _l('view'); ?>">
                                                                    <i class="fa-solid fa-eye"></i> <?php echo _l('view'); ?>
                                                                </a>
                                                            <?php } ?>
                                                            <?php if((has_permission('workshop_device', '', 'edit') || is_admin())){ ?>
                                                                <a href="#" onclick="device_modal(<?php echo $device['id']; ?>); return false;" class="btn btn-info" style="flex: 1; padding: 8px 0;" title="<?php echo _l('edit'); ?>">
                                                                    <i class="fa-regular fa-pen-to-square"></i> <?php echo _l('edit'); ?>
                                                                </a>
                                                            <?php } ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                            </div>
                            
                            <?php if(count($devices) > $initial_limit){ ?>
                            <div class="row text-center" id="load-more-container" style="margin-top: 15px; margin-bottom: 15px;">
                                <button type="button" class="btn btn-info btn-lg" onclick="load_more_devices()"><?php echo _l('load_more'); ?> <i class="fa fa-angle-down"></i></button>
                            </div>
                            <?php } ?>
                        </div>

                        <div id="device-list-view" class="hide">
                        <?php 
                        render_datatable(
                            array(
                                _l('id'),
                                _l('wshop_image'),
                                _l('wshop_code'),
                                _l('wshop_name'),
                                'Гос. номер',
                                _l('client'),
                                _l('wshop_model'),
                                _l('wshop_category'),
                                _l('wshop_manufacturer'),
                                _l('wshop_purchase_date'),
                                _l('wshop_last_maintenance_date'),
                                _l('wshop_next_maintenance_date'),
                                _l('wshop_warranty_period_months'),
                                _l('wshop_warranty_expiry_date'),
                                _l('wshop_warranty_status'),
                                _l('wshop_status'),
                                [
                                    'name'  => _l('options'),
                                    'th_attrs' => [
                                        'style' => 'min-width:80px',
                                    ],
                                ],
                            ),'device_table'
                        );
                        ?>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div id="modal_wrapper"></div>

<?php init_tail(); ?>

<?php require('modules/workshop/assets/js/devices/manage_js.php'); ?>
</body>
</html>
